#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#    Diferentes funciones para jugar con fechas y archivos
#    Copyright (C) 2013  Víctor Fernández <vfrico@gmail.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
import time
def conseguir_lista():
    datos = open("lista.txt", 'r')
    lista_raw = datos.read().split("\n")
    lista = []
    for i in lista_raw:
        try:
            dos = i.split(" ")
            lista.append([dos[0], dos[1]])
        except:
            None
    return lista[1:-1]

def separardias():
    # Devuelve una lista, dentro de la lista otra 
    #  lista con el conjunto de todos los datos
    datos = conseguir_lista()
    diasDist = {}
    for par in datos:
        #Un día tiene 86400 seg
        tiempo = int(par[0])
        articulo = int(par[1])
        dia = time.localtime(tiempo).tm_mday
        mes = time.localtime(tiempo).tm_mon
        ano = time.localtime(tiempo).tm_year
        fecha = str(dia)+"/"+str(mes)+"/"+str(ano)
        try:
            tupla_ext = diasDist[fecha]
            tupla_ext.append(articulo)
            tupla = tupla_ext
        except:
            #crear tupla
            tupla = [articulo]
        diasDist[fecha] = tupla
    return diasDist

def sumaArray(array):
    res = 0
    for i in array:
        res = i + res
        
    return res

def calcularMedia(dicc):
    keys = dicc.keys()
    for i in keys:
        media = int((sumaArray(dicc.get(i)))/(len(dicc.get(i))))
        dicc[i] = media
    return dicc
    
##########################
### Nuevo
##########################
def dosCadaDia(lista):
    """Devuelve una lista con dos valores por día
    lista debe ser [[posix,art],[posix,art]...]
    """
    salida = []
    #Cada día se graban 48 registros (uno cada media hora)
    todos = len(lista)
    for i in range(0, todos//48 + 1):
        salida.append(lista[i*48])
    #Añadir también el último registro
    salida.append(lista[-1])
    return salida

def posixAFechaDia(posix):
    """Dada un valor en fecha posix, devuelve una
    cadena con la fecha (AAAA/MM/DD) correspondiente"""
    dia = time.localtime(posix).tm_mday
    mes = time.localtime(posix).tm_mon
    ano = time.localtime(posix).tm_year
    fecha = str(ano)+"/"+str(mes)+"/"+str(dia)
    return fecha

def diferenciaDias(lista):
    """Añade una nueva columna para saber
    la diferencia cada día."""
    # Añadir la diferencia como ultimo elemento
    for i in lista:
        if i == lista[0]:
            #Primer elemento, poner 0
            i.append('0')
        else:
            iAnt = lista.index(i) - 1
            #print (iAnt)
            anterior = int(lista[iAnt][1])
            i.append(str(-anterior + int(i[1])))
    
    # Modificar el primer elemento de la lista, 
    # para que muestre el día de una forma "amigable"
    for i in lista:
        i[0] = posixAFechaDia(int(i[0]))
    return lista
        

def convertirListaACadena(lista):
    cadena = ""
    for i in lista:
        #print ("i: '" + str(lista) + "'")
        cadena += str(i) + " \t"
    return cadena
    
def escribirListaArchivo(lista, ruta):
    """Escribe una lista a un archivo, 
    por cada línea, un elemento"""
    archivo = open(ruta, 'w')
    #print (lista)
    for i in lista:
        archivo.write(convertirListaACadena(i)+"\n")
        

valores = diferenciaDias(dosCadaDia(conseguir_lista()))
#print (conseguir_lista())
#print (dosCadaDia(conseguir_lista()))
#print (valores)
dir = "diferencia.txt"
escribirListaArchivo(valores, dir)

